/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.convertidores.BooleanNegativeConverter;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.Sujeto;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.rendimiento.valores.ModeloValoresRetenido;
import ec.gob.sri.dimm.ats.modelo.obj.rendimientos.Rendimiento;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.wb.swt.SWTResourceManager;

public class DialogoRetenido
extends DialogoBase
implements VistaModelo<Rendimiento>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private boolean editando;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private Rendimiento modeloDatos;
    private ModeloValoresRetenido modeloValores;
    private Text txtNumIdentificacion;
    private ComboViewer cvTipoIdentificacion;
    private Text txtTotalAho;
    private Text txtRendimientoAho;
    private Text txtTotalCtex;
    private Text txtRendimientoCtex;
    private List<Sujeto> retenidos;
    private Sujeto sujetoActual = new Sujeto();
    private final Periodo periodo;
    private Button btnCheckButton;
    private Label lblInformacinDelPago;
    private Label lblRendimientoGenerado;
    private Label lblTotalDepsito;
    private Label lblCuentasExcentas;
    private Label label;
    private Label label_1;
    private Label lblesParteRelacionada;
    private Composite compParteRel;
    private Button btnSiParRel;
    private Button btnNoParRel;
    private Label lblTipoDeRetenido;
    private Combo cmbTipoRetenido;
    private ComboViewer cvTipoDeRetenido;
    private Label lblRazonSocial;
    private Text txtRazonSocial;

    public DialogoRetenido(IWorkbenchPartSite site, List<Sujeto> retenidos, boolean editando, Periodo periodo) {
        super(site);
        this.setShellStyle(80);
        this.retenidos = retenidos;
        this.editando = editando;
        this.periodo = periodo;
    }

    public void setModeloDatos(Rendimiento modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.sujetoActual = modeloDatos.getRetenido();
        }
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresRetenido();
        this.modeloValores.inicializar();
    }

    protected Point getInitialSize() {
        return new Point(482, 482);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Especifique la informaci\u00f3n del Retenido \\ Ahorros y  Cuentas Exentas son opcionales");
        this.setTitle("Informaci\u00f3n del Sujeto Retenido");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblInformacinDelRetenido = new Label(container, 0);
        lblInformacinDelRetenido.setText("Informaci\u00f3n del Retenido");
        lblInformacinDelRetenido.setFont(SWTResourceManager.getBoldFont((Font)lblInformacinDelRetenido.getFont()));
        new Label(container, 0);
        Label lblTipoIdentificacinBeneficiario = new Label(container, 0);
        GridData gd_lblTipoIdentificacinBeneficiario = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoIdentificacinBeneficiario.widthHint = 125;
        lblTipoIdentificacinBeneficiario.setLayoutData((Object)gd_lblTipoIdentificacinBeneficiario);
        lblTipoIdentificacinBeneficiario.setText("Tipo Identificaci\u00f3n ");
        this.cvTipoIdentificacion = new ComboViewer(container, 8);
        this.cmbTipoIdentificacionSelectionChanged();
        Combo combo_2 = this.cvTipoIdentificacion.getCombo();
        GridData gd_combo_2 = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_combo_2.widthHint = 246;
        combo_2.setLayoutData((Object)gd_combo_2);
        Label lblNIdentificacin = new Label(container, 0);
        lblNIdentificacin.setText("N\u00b0 identificaci\u00f3n");
        this.txtNumIdentificacion = new Text(container, 2048);
        this.txtNumIdentificacion.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoRetenido.this.txtNumIdentificacion.selectAll();
            }
        });
        this.txtNumIdentificacion.setTextLimit(13);
        GridData gd_txtNumIdentificacion = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtNumIdentificacion.widthHint = 100;
        this.txtNumIdentificacion.setLayoutData((Object)gd_txtNumIdentificacion);
        this.lblesParteRelacionada = new Label(container, 0);
        this.lblesParteRelacionada.setText("\u00bfEs parte relacionada?");
        this.compParteRel = new Composite(container, 0);
        this.compParteRel.setLayout((Layout)new GridLayout(2, false));
        this.btnSiParRel = new Button(this.compParteRel, 16);
        this.btnSiParRel.setText("SI");
        this.btnNoParRel = new Button(this.compParteRel, 16);
        this.btnNoParRel.setText("NO");
        this.lblTipoDeRetenido = new Label(container, 0);
        this.lblTipoDeRetenido.setText("Tipo de Retenido ");
        this.lblTipoDeRetenido.setVisible(false);
        this.cvTipoDeRetenido = new ComboViewer(container, 8);
        this.tipoRetenidoClicked();
        this.cmbTipoRetenido = this.cvTipoDeRetenido.getCombo();
        this.cmbTipoRetenido.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbTipoRetenido.setVisible(false);
        this.lblRazonSocial = new Label(container, 0);
        this.lblRazonSocial.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblRazonSocial.setText("Raz\u00f3n o denominaci\u00f3n social del retenido");
        this.lblRazonSocial.setVisible(false);
        this.txtRazonSocial = new Text(container, 2048);
        this.txtRazonSocial.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.text = e.text.toUpperCase();
            }
        });
        this.txtRazonSocial.setTextLimit(500);
        this.txtRazonSocial.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRazonSocial.setVisible(false);
        Composite composite_2 = new Composite(container, 0);
        composite_2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        composite_2.setLayout((Layout)new GridLayout(2, false));
        Label lblNewLabel = new Label(composite_2, 0);
        lblNewLabel.setText("\u00bfTiene Cuentas de Ahorro o Cuentas Exentas?");
        this.btnCheckButton = new Button(composite_2, 32);
        this.btnCheckButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DialogoRetenido.this.btnCheckButton.getSelection()) {
                    DialogoRetenido.this.modeloDatos.getCuentaAhorro().reiniciar();
                    DialogoRetenido.this.modeloDatos.getCuentaExcenta().reiniciar();
                }
            }
        });
        this.lblInformacinDelPago = new Label(container, 0);
        GridData gd_lblInformacinDelPago = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_lblInformacinDelPago.verticalIndent = 10;
        this.lblInformacinDelPago.setLayoutData((Object)gd_lblInformacinDelPago);
        this.lblInformacinDelPago.setText("Ahorros Personas Naturales (Ingresar informaci\u00f3n solo si el retenido la tiene)");
        this.lblInformacinDelPago.setFont(SWTResourceManager.getBoldFont((Font)this.lblInformacinDelPago.getFont()));
        Composite composite = new Composite(container, 0);
        GridLayout gl_composite = new GridLayout(4, false);
        gl_composite.marginWidth = 0;
        composite.setLayout((Layout)gl_composite);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.lblTotalDepsito = new Label(composite, 0);
        this.lblTotalDepsito.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.lblTotalDepsito.setText("Total Dep\u00f3sito");
        this.txtTotalAho = new Text(composite, 2048);
        this.txtTotalAho.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoRetenido.this.txtTotalAho.selectAll();
            }
        });
        this.txtTotalAho.setTextLimit(15);
        GridData gd_txtTotalAho = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtTotalAho.widthHint = 80;
        this.txtTotalAho.setLayoutData((Object)gd_txtTotalAho);
        this.lblRendimientoGenerado = new Label(composite, 0);
        GridData gd_lblRendimientoGenerado = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_lblRendimientoGenerado.widthHint = 125;
        this.lblRendimientoGenerado.setLayoutData((Object)gd_lblRendimientoGenerado);
        this.lblRendimientoGenerado.setText("Rendimiento  Generado");
        this.txtRendimientoAho = new Text(composite, 2048);
        this.txtRendimientoAho.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoRetenido.this.txtRendimientoAho.selectAll();
            }
        });
        this.txtRendimientoAho.setTextLimit(15);
        GridData gd_txtRendimientoAho = new GridData(4, 128, true, false, 1, 1);
        gd_txtRendimientoAho.widthHint = 80;
        this.txtRendimientoAho.setLayoutData((Object)gd_txtRendimientoAho);
        this.lblCuentasExcentas = new Label(container, 0);
        GridData gd_lblCuentasExcentas = new GridData(16384, 0x1000000, false, false, 2, 1);
        gd_lblCuentasExcentas.verticalIndent = 10;
        this.lblCuentasExcentas.setLayoutData((Object)gd_lblCuentasExcentas);
        this.lblCuentasExcentas.setText("Cuentas Exentas (Ingresar informaci\u00f3n solo si el retenido la tiene)");
        this.lblCuentasExcentas.setFont(SWTResourceManager.getFont((String)"Segoe UI", (int)9, (int)1));
        Composite composite_1 = new Composite(container, 0);
        composite_1.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        GridLayout gl_composite_1 = new GridLayout(4, false);
        gl_composite_1.marginWidth = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.label = new Label(composite_1, 0);
        this.label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.label.setText("Total Dep\u00f3sito");
        this.txtTotalCtex = new Text(composite_1, 2048);
        this.txtTotalCtex.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoRetenido.this.txtTotalCtex.selectAll();
            }
        });
        this.txtTotalCtex.setTextLimit(15);
        GridData gd_txtTotalCtex = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtTotalCtex.widthHint = 80;
        this.txtTotalCtex.setLayoutData((Object)gd_txtTotalCtex);
        this.label_1 = new Label(composite_1, 0);
        GridData gd_label_1 = new GridData(131072, 0x1000000, false, false, 1, 1);
        gd_label_1.widthHint = 125;
        this.label_1.setLayoutData((Object)gd_label_1);
        this.label_1.setText("Rendimiento  Generado");
        this.txtRendimientoCtex = new Text(composite_1, 2048);
        this.txtRendimientoCtex.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoRetenido.this.txtRendimientoCtex.selectAll();
            }
        });
        this.txtRendimientoCtex.setTextLimit(15);
        GridData gd_txtRendimientoCtex = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtRendimientoCtex.widthHint = 80;
        this.txtRendimientoCtex.setLayoutData((Object)gd_txtRendimientoCtex);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    private void cmbTipoIdentificacionSelectionChanged() {
        this.cvTipoIdentificacion.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent arg0) {
                ElementoNombreValor tipoIdentificacion = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)arg0);
                if (tipoIdentificacion != null) {
                    DialogoRetenido.this.modeloDatos.getRetenido().setTipoIdentificacion((String)tipoIdentificacion.getValor());
                    DialogoRetenido.this.modeloDatos.getRetenido().setDescripcionTipoIdentificacion(tipoIdentificacion.getNombre());
                    DialogoRetenido.this.mostrarTipoDeRetenidoYRazonSocialDesdeMayo2016((ElementoNombreValor<String>)tipoIdentificacion);
                }
            }
        });
    }

    private void mostrarTipoDeRetenidoYRazonSocialDesdeMayo2016(ElementoNombreValor<String> tipoIdentificacion) {
        boolean esPasaporteYPeriodoDesdeMayo2016 = "P".equals(tipoIdentificacion.getValor()) && ((Iva)this.modeloDatos.getRaizModelo()).periodo.isAnexoEnPeriodoDesdeMayo2016();
        this.lblRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.txtRazonSocial.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.lblTipoDeRetenido.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        this.cmbTipoRetenido.setVisible(esPasaporteYPeriodoDesdeMayo2016);
        if (!esPasaporteYPeriodoDesdeMayo2016) {
            this.txtRazonSocial.setText("");
            this.modeloDatos.getRetenido().setTipoProveedor(null);
            this.modeloDatos.getRetenido().setDescripcionTipoProveedor("");
        }
    }

    private void tipoRetenidoClicked() {
        this.cvTipoDeRetenido.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoContribuyente = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoContribuyente != null) {
                    DialogoRetenido.this.modeloDatos.getRetenido().setTipoProveedor((String)tipoContribuyente.getValor());
                    DialogoRetenido.this.modeloDatos.getRetenido().setDescripcionTipoProveedor(tipoContribuyente.getNombre());
                }
            }
        });
    }

    public void procesarModeloDatos() {
        String codigoTipoIdentificacion = this.modeloDatos.getRetenido().getTipoIdentificacion();
        ElementoNombreValor tipoIdentificacion = this.modeloValores.obtenerTipoIdentificacion(codigoTipoIdentificacion);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoIdentificacion, (Object)tipoIdentificacion);
        String tipoRetenido = this.modeloDatos.getRetenido().getTipoProveedor();
        ElementoNombreValor elementoTipoRetenido = this.modeloValores.obtenerTipoDeRetenido(tipoRetenido);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoDeRetenido, (Object)elementoTipoRetenido);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoRetenido.this.modeloDatos.getRetenido().equals((Object)DialogoRetenido.this.sujetoActual)) {
                    Sujeto cTemp = new Sujeto();
                    cTemp.setTipoIdentificacion(DialogoRetenido.this.modeloDatos.getRetenido().getTipoIdentificacion());
                    cTemp.setIdentificacion(DialogoRetenido.this.modeloDatos.getRetenido().getIdentificacion());
                    if (DialogoRetenido.this.retenidos.contains(cTemp)) {
                        resultado.fallarValidacion("El Retenido ya se encuentra registrado");
                    }
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getRetenido().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getCuentaAhorro().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getCuentaExcenta().addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getRetenido().removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getCuentaAhorro().removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        this.modeloDatos.getCuentaExcenta().removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider_2 = new ObservableListContentProvider();
        IObservableMap observeMap_2 = PojoObservables.observeMap((IObservableSet)listContentProvider_2.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoIdentificacion.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap_2));
        this.cvTipoIdentificacion.setContentProvider((IContentProvider)listContentProvider_2);
        IObservableList tiposIdentificacionModeloValoresObserveList = PojoProperties.list((String)"tiposIdentificacion").observe((Object)this.modeloValores);
        this.cvTipoIdentificacion.setInput((Object)tiposIdentificacionModeloValoresObserveList);
        ISWTObservableValue observeTextTxtRendimientoAhoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtRendimientoAho);
        IObservableValue cuentaAhorrorendimientoGeneradoModeloDatosObserveValue = BeanProperties.value((String)"cuentaAhorro.rendimientoGenerado").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtRendimientoAhoObserveWidget, cuentaAhorrorendimientoGeneradoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtTotalAhoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtTotalAho);
        IObservableValue cuentaAhorrototalDepositoModeloDatosObserveValue = BeanProperties.value((String)"cuentaAhorro.totalDeposito").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtTotalAhoObserveWidget, cuentaAhorrototalDepositoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtTotalCtexObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtTotalCtex);
        IObservableValue cuentaExcentatotalDepositoModeloDatosObserveValue = BeanProperties.value((String)"cuentaExcenta.totalDeposito").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtTotalCtexObserveWidget, cuentaExcentatotalDepositoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtRendimientoCtexObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtRendimientoCtex);
        IObservableValue cuentaExcentarendimientoGeneradoModeloDatosObserveValue = BeanProperties.value((String)"cuentaExcenta.rendimientoGenerado").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtRendimientoCtexObserveWidget, cuentaExcentarendimientoGeneradoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtNumIdentificacionObserveWidget_1 = WidgetProperties.text((int)24).observe((Widget)this.txtNumIdentificacion);
        IObservableValue retenidoidentificacionModeloDatosObserveValue = BeanProperties.value((String)"retenido.identificacion").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtNumIdentificacionObserveWidget_1, retenidoidentificacionModeloDatosObserveValue, null, null);
        ISWTObservableValue observeSelectionBtnCheckButtonObserveWidget = WidgetProperties.selection().observe((Widget)this.btnCheckButton);
        IObservableValue tieneCuentasModeloDatosObserveValue = BeanProperties.value((String)"tieneCuentas").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeSelectionBtnCheckButtonObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLblInformacinDelPagoObserveWidget = WidgetProperties.enabled().observe((Widget)this.lblInformacinDelPago);
        bindingContext.bindValue((IObservableValue)observeEnabledLblInformacinDelPagoObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLblRendimientoGeneradoObserveWidget = WidgetProperties.enabled().observe((Widget)this.lblRendimientoGenerado);
        bindingContext.bindValue((IObservableValue)observeEnabledLblRendimientoGeneradoObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledTxtTotalAhoObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtTotalAho);
        bindingContext.bindValue((IObservableValue)observeEnabledTxtTotalAhoObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLblTotalDepsitoObserveWidget = WidgetProperties.enabled().observe((Widget)this.lblTotalDepsito);
        bindingContext.bindValue((IObservableValue)observeEnabledLblTotalDepsitoObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLblCuentasExcentasObserveWidget = WidgetProperties.enabled().observe((Widget)this.lblCuentasExcentas);
        bindingContext.bindValue((IObservableValue)observeEnabledLblCuentasExcentasObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLabelObserveWidget = WidgetProperties.enabled().observe((Widget)this.label);
        bindingContext.bindValue((IObservableValue)observeEnabledLabelObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledLabel_1ObserveWidget = WidgetProperties.enabled().observe((Widget)this.label_1);
        bindingContext.bindValue((IObservableValue)observeEnabledLabel_1ObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledTxtRendimientoCtexObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtRendimientoCtex);
        bindingContext.bindValue((IObservableValue)observeEnabledTxtRendimientoCtexObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledTxtTotalCtexObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtTotalCtex);
        bindingContext.bindValue((IObservableValue)observeEnabledTxtTotalCtexObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue observeEnabledTxtRendimientoAhoObserveWidget = WidgetProperties.enabled().observe((Widget)this.txtRendimientoAho);
        bindingContext.bindValue((IObservableValue)observeEnabledTxtRendimientoAhoObserveWidget, tieneCuentasModeloDatosObserveValue, null, null);
        ISWTObservableValue btnSiParRelObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnSiParRel);
        IObservableValue modeloDatosRetenidoparteRelacionadaObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retenido.parteRelacionada");
        bindingContext.bindValue((IObservableValue)btnSiParRelObserveSelectionObserveWidget, modeloDatosRetenidoparteRelacionadaObserveValue, null, null);
        ISWTObservableValue btnNoParRelObserveSelectionObserveWidget = SWTObservables.observeSelection((Control)this.btnNoParRel);
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setConverter((IConverter)new BooleanNegativeConverter());
        UpdateValueStrategy strategy_1 = new UpdateValueStrategy();
        strategy_1.setConverter((IConverter)new BooleanNegativeConverter());
        bindingContext.bindValue((IObservableValue)btnNoParRelObserveSelectionObserveWidget, modeloDatosRetenidoparteRelacionadaObserveValue, strategy, strategy_1);
        ISWTObservableValue lblesParteRelacionadaObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.lblesParteRelacionada);
        IObservableValue periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue = PojoObservables.observeValue((Object)this.periodo, (String)"periodoDeAnexoDesdeMarzo2015");
        bindingContext.bindValue((IObservableValue)lblesParteRelacionadaObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue btnSiParRelObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.btnSiParRel);
        bindingContext.bindValue((IObservableValue)btnSiParRelObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ISWTObservableValue btnNoParRelObserveVisibleObserveWidget = SWTObservables.observeVisible((Control)this.btnNoParRel);
        bindingContext.bindValue((IObservableValue)btnNoParRelObserveVisibleObserveWidget, periodoPeriodoDeAnexoDesdeMarzo2015ObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoDeRetenido.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoDeRetenido.setContentProvider((IContentProvider)listContentProvider);
        IObservableList modeloValoresTiposDeRetenidoObserveList = PojoObservables.observeList((Realm)Realm.getDefault(), (Object)this.modeloValores, (String)"tiposDeRetenido");
        this.cvTipoDeRetenido.setInput((Object)modeloValoresTiposDeRetenidoObserveList);
        ISWTObservableValue txtRazonSocialObserveTextObserveWidget = SWTObservables.observeText((Control)this.txtRazonSocial, (int)24);
        IObservableValue modeloDatosRetenidorazonSocialObserveValue = BeansObservables.observeValue((Object)this.modeloDatos, (String)"retenido.razonSocial");
        bindingContext.bindValue((IObservableValue)txtRazonSocialObserveTextObserveWidget, modeloDatosRetenidorazonSocialObserveValue, null, null);
        return bindingContext;
    }
}

